/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1860;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesGenerator
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesGenerator INSTANCE = new ServerDynamicResourcesGenerator();
    public static final Map<class_2960, class_3298> R = new HashMap<class_2960, class_3298>();

    public ServerDynamicResourcesGenerator() {
        super(new DynamicDataPack(Supplementaries.res("generated_pack")));
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)Supplementaries.res("way_signs"));
            builder.addEntries(ModRegistry.WAY_SIGN_ITEMS.values());
            sink.addTag(builder, class_7924.field_41197);
            builder = SimpleTagBuilder.of((class_2960)Supplementaries.res("cannon_boats"));
            builder.addEntries(ModRegistry.CANNON_BOAT_ITEMS.values());
            sink.addTag(builder, class_7924.field_41197);
            if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
                this.addSignPostRecipes(manager, sink);
            }
            if (CommonConfigs.Functional.CANNON_BOAT_ENABLED.get().booleanValue()) {
                this.addCannonBoatRecipes(manager, sink);
            }
            if (PlatHelper.getPlatform().isForge()) {
                builder = SimpleTagBuilder.of(ModTags.HAS_WAY_SIGNS);
                if (CommonConfigs.Building.ROAD_SIGN_ENABLED.get().booleanValue() && CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_37393);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_CAVE_URNS);
                if (CommonConfigs.Functional.URN_PILE_ENABLED.get().booleanValue() && CommonConfigs.Functional.URN_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_37393);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_WILD_FLAX);
                if (CommonConfigs.Functional.WILD_FLAX_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_37393);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_BASALT_ASH);
                if (CommonConfigs.Building.BASALT_ASH_ENABLED.get().booleanValue()) {
                    builder.add(class_1972.field_23859.method_29177());
                    builder.method_34891(class_2960.method_60654((String)"incendium:volcanic_deltas"));
                }
                sink.addTag(builder, class_7924.field_41236);
            }
        });
    }

    private void addCannonBoatRecipes(class_3300 manager, ResourceSink sink) {
        class_1860 recipeTemplate = RPUtils.readRecipe((class_3300)manager, (class_2960)Supplementaries.res("cannon_boat_oak"));
        WoodType oak = VanillaWoodTypes.OAK;
        ModRegistry.CANNON_BOAT_ITEMS.forEach((w, i) -> {
            WoodType bamboo = (WoodType)WoodTypeRegistry.INSTANCE.get(class_2960.method_60656((String)"bamboo"));
            if (w != oak && w != bamboo) {
                try {
                    class_8786 newR = RPUtils.makeSimilarRecipe((class_1860)recipeTemplate, (BlockType)VanillaWoodTypes.OAK, (BlockType)w, (class_2960)Supplementaries.res("cannon_boat_oak"));
                    sink.addRecipe(newR);
                    sink.markNotClearable(newR.comp_1932());
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to generate recipe for cannon boat {}:", (Object)i, (Object)e);
                }
            }
        });
    }

    private void addSignPostRecipes(class_3300 manager, ResourceSink sink) {
        class_1860 recipe = RPUtils.readRecipe((class_3300)manager, (class_2960)Supplementaries.res("way_sign_oak"));
        class_1860 recipe2 = RPUtils.readRecipe((class_3300)manager, (class_2960)Supplementaries.res("way_sign_mod_template"));
        WoodType oak = VanillaWoodTypes.OAK;
        ModRegistry.WAY_SIGN_ITEMS.forEach((w, i) -> {
            if (w != oak) {
                try {
                    class_1860 recipeTemplate = w.getChild("sign") == null ? recipe2 : recipe;
                    class_8786 newR = RPUtils.makeSimilarRecipe((class_1860)recipeTemplate, (BlockType)VanillaWoodTypes.OAK, (BlockType)w, (class_2960)Supplementaries.res("way_sign_oak"));
                    sink.addRecipe(newR);
                    sink.markNotClearable(newR.comp_1932());
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to generate recipe for sign post {}:", (Object)i, (Object)e);
                }
            }
        });
    }
}

